<?php

include_once '../includes/autoloader.php';
class bank extends dbh
{
    private $id;
    private $fname;
    private $middlename;
    private $lname;
    private $email;
    private $tel_number;
    private $gender;
    private $postal_code;
    private $country;
    private $state;
    private $address;
    private $dob;
    private $pass;
    private $profile_pic;
    private $password;
    private $pin;
    private $account_number;
    private $account_type;
    private $balance;
    private $ip;
    private $date_registered;
    private $status;
    private $allowed;
    private $currency;
    private $epin;
    private $dis;
    private $code;
    private $ssn;
    private $PersonalTransactionKey;
    private $TaxClearanceCode;
    private $IMFClearanceCode;
    private $AntiTerrorismClearanceCode;
    private $btc;
    private $dbconn;
    public static $createdOn;
    private $sender;
    private $recipient;
    private $transferAmount;
    private $transProDate;
    private $transferFee;
    private $percentage;
    private $transfeeStatus;
    private $maturityDate;
    private $maturityDateStatus;
    private $encryption;
    private $dislog;
    public function setSender($sender)
    {
        $this->sender = $sender;
    }

    public function getSender()
    {
        return $this->sender;
    }

    public function setRecipient($recipient)
    {
        $this->recipient = $recipient;
    }

    public function getRecipient()
    {
        return $this->recipient;
    }

    public function setTransferAmount($transferAmount)
    {
        $this->transferAmount = $transferAmount;
    }

    public function getTransferAmount()
    {
        return $this->transferAmount;
    }

    public function setTransProDate($transProDate)
    {
        $this->transProDate = $transProDate;
    }

    public function getTransProDate()
    {
        return $this->transProDate;
    }

    public function setTransferFee($transferFee)
    {
        $this->transferFee = $transferFee;
    }

    public function getTransferFee()
    {
        return $this->transferFee;
    }

    public function setPercentage($percentage)
    {
        $this->percentage = $percentage;
    }

    public function getPercentage()
    {
        return $this->percentage;
    }

    public function setTransfeeStatus($transfeeStatus)
    {
        $this->transfeeStatus = $transfeeStatus;
    }

    public function getTransfeeStatus()
    {
        return $this->transfeeStatus;
    }

    public function setMaturityDate($maturityDate)
    {
        $this->maturityDate = $maturityDate;
    }

    public function getMaturityDate()
    {
        return $this->maturityDate;
    }

    public function setMaturityDateStatus($maturityDateStatus)
    {
        $this->maturityDateStatus = $maturityDateStatus;
    }

    public function getMaturityDateStatus()
    {
        return $this->maturityDateStatus;
    }

    public function setEncryption($encryption)
    {
        $this->encryption = $encryption;
    }

    public function getEncryption()
    {
        return $this->encryption;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function getId()
    {
        return $this->id;
    }

    public function setbtc($btc)
    {
        $this->btc = $btc;
    }
    public function getbtc()
    {
        return $this->btc;
    }

    public function setmiddlename($middlename)
    {
        $this->middlename = $middlename;
    }
    public function getmiddlename()
    {
        return $this->middlename;
    }

    public function setpostal_code($postal_code)
    {
        $this->postal_code = $postal_code;
    }
    public function getpostal_code()
    {
        return $this->postal_code;
    }



    public function setgender($gender)
    {
        $this->gender = $gender;
    }
    public function getgender()
    {
        return $this->gender;
    }


    public function setfname($fname)
    {
        $this->fname = $fname;
    }

    public function getfname()
    {
        return $this->fname;
    }

    public function setlname($lname)
    {
        $this->lname = $lname;
    }

    public function getlname()
    {
        return $this->lname;
    }

    public function getemail()
    {
        return $this->email;
    }
    public function setemail($email)
    {
        $this->email = $email;
    }

    public function gettel_number()
    {
        return $this->tel_number;
    }
    public function settel_number($tel_number)
    {
        $this->tel_number = $tel_number;
    }

    public function getcountry()
    {
        return $this->country;
    }
    public function setcountry($country)
    {
        $this->country = $country;
    }

    public function getstate()
    {
        return $this->state;
    }
    public function setstate($state)
    {
        $this->state = $state;
    }

    public function getaddress()
    {
        return $this->address;
    }
    public function setaddress($address)
    {
        $this->address = $address;
    }

    public function getdob()
    {
        return $this->dob;
    }
    public function setdob($dob)
    {
        $this->dob = $dob;
    }


    public function setcode($code)
    {
        $this->code = $code;
    }
    public function getcode()
    {
        return $this->code;
    }

    public function getprofile_pic()
    {
        return $this->profile_pic;
    }
    public function setprofile_pic($profile_pic)
    {
        $this->profile_pic = $profile_pic;
    }

    public function getpassword()
    {
        return $this->password;
    }
    public function setpassword($password)
    {
        $this->password = $password;
    }

    public function getpass()
    {
        return $this->pass;
    }
    public function setpass($pass)
    {
        $this->pass = $pass;
    }

    public function getpin()
    {
        return $this->pin;
    }
    public function setpin($pin)
    {
        $this->pin = $pin;
    }

    public function getaccount_number()
    {
        return $this->account_number;
    }
    public function setaccount_number($account_number)
    {
        $this->account_number = $account_number;
    }

    public function getaccount_type()
    {
        return $this->account_type;
    }
    public function setaccount_type($account_type)
    {
        $this->account_type = $account_type;
    }

    public function getbalance()
    {
        return $this->balance;
    }
    public function setbalance($balance)
    {
        $this->balance = $balance;
    }

    public function getip()
    {
        return $this->ip;
    }
    public function setip($ip)
    {
        $this->ip = $ip;
    }

    public function getdate_registered()
    {
        return $this->date_registered;
    }
    public function setdate_registered($date_registered)
    {
        $this->date_registered = $date_registered;
    }

    public function getstatus()
    {
        return $this->status;
    }
    public function setstatus($status)
    {
        $this->status = $status;
    }

    public function getallowed()
    {
        return $this->allowed;
    }
    public function setallowed($allowed)
    {
        $this->allowed = $allowed;
    }

    public function setcurrency($currency)
    {
        $this->currency = $currency;
    }

    public function getcurrency()
    {
        return $this->currency;
    }

    public function setepin($epin)
    {
        $this->epin = $epin;
    }

    public function getepin()
    {
        return $this->epin;
    }

    public function setdislog($dislog)
    {
        $this->dislog = $dislog;
    }

    public function getdislog()
    {
        return $this->dislog;
    }

    public function setdis($dis)
    {
        $this->dis = $dis;
    }

    public function getdis()
    {
        return $this->dis;
    }

    public function setPersonalTransactionKey($PersonalTransactionKey)
    {
        $this->PersonalTransactionKey = $PersonalTransactionKey;
    }

    public function getPersonalTransactionKey()
    {
        return $this->PersonalTransactionKey;
    }


    public function setTaxClearanceCode($TaxClearanceCode)
    {
        $this->TaxClearanceCode = $TaxClearanceCode;
    }

    public function getTaxClearanceCode()
    {
        return $this->TaxClearanceCode;
    }


    public function setIMFClearanceCode($IMFClearanceCode)
    {
        $this->IMFClearanceCode = $IMFClearanceCode;
    }

    public function getIMFClearanceCode()
    {
        return $this->IMFClearanceCode;
    }

    public function setAntiTerrorismClearanceCode($AntiTerrorismClearanceCode)
    {
        $this->AntiTerrorismClearanceCode = $AntiTerrorismClearanceCode;
    }

    public function getAntiTerrorismClearanceCode()
    {
        return $this->AntiTerrorismClearanceCode;
    }

    public static function setDateTime()
    {
        self::$createdOn = date('d-m-Y h:i:s a', time());
    }

    public function __construct()
    {
        $db = new dbh();
        $this->dbconn = $db->connect();
    }
    public function save()
    {


        $sql = "INSERT INTO `users`(id, fname, middlename, lname, email, tel_number, postal_code, currency, gender, country, state, address, dob, pass, profile_pic, password, pin, account_number, account_type, balance, ip, date_registered, status, allowed, epin, dis, PersonalTransactionKey, TaxClearanceCode, IMFClearanceCode, AntiTerrorismClearanceCode)VALUES(NULL, :fname, :middlename, :lname, :email, :tel_number, :postal_code, :currency, :gender, :country, :state, :address, :dob, :pass, :profile_pic, :password, :pin, :account_number, :account_type, :balance, :ip, :date_registered, :status,:allowed, :epin, :dis, :PersonalTransactionKey, :TaxClearanceCode, :IMFClearanceCode, :AntiTerrorismClearanceCode)";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":fname", $this->fname);
        $conn->bindParam(":middlename", $this->middlename);
        $conn->bindParam(":lname", $this->lname);
        $conn->bindParam(":email", $this->email);
        $conn->bindParam(":tel_number", $this->tel_number);
        $conn->bindParam(":postal_code", $this->postal_code);
        $conn->bindParam(":gender", $this->gender);
        $conn->bindParam(":currency", $this->currency);
        $conn->bindParam(":country", $this->country);
        $conn->bindParam(":state", $this->state);
        $conn->bindParam(":address", $this->address);
        $conn->bindParam(":dob", $this->dob);
        $conn->bindParam(":pass", $this->pass);
        $conn->bindParam(":profile_pic", $this->profile_pic);
        $conn->bindParam(":password", $this->password);
        $conn->bindParam(":account_number", $this->account_number);
        $conn->bindParam(":account_type", $this->account_type);
        $conn->bindParam(":balance", $this->balance);
        $conn->bindParam(":ip", $this->ip);
        $conn->bindParam(":date_registered", self::$createdOn);
        $conn->bindParam(":status", $this->status);
        $conn->bindParam(":allowed", $this->allowed);
        $conn->bindParam(":epin", $this->epin);
        $conn->bindParam(":pin", $this->pin);
        $conn->bindParam(":dis", $this->dislog);
        $conn->bindParam(":PersonalTransactionKey", $this->PersonalTransactionKey);
        $conn->bindParam(":TaxClearanceCode", $this->TaxClearanceCode);
        $conn->bindParam(":IMFClearanceCode", $this->IMFClearanceCode);
        $conn->bindParam(":AntiTerrorismClearanceCode", $this->AntiTerrorismClearanceCode);
        // $conn->bindParam(":bitcoin", $this->btc);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function updateProgress($id)
    {
        $sql = "UPDATE `progress` 
            SET sender = :sender, 
            reciepient = :recipient, 
                Transferamount = :transferAmount, 
                transProDate = :transProDate, 
                TransferFee = :transferFee, 
                percentage = :percentage, 
                transfeeStatus = :transfeeStatus, 
                maturityDate = :maturityDate, 
                maturityDateStatus = :maturityDateStatus,  
                Country = :country WHERE id = $id";

        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(':sender', $this->sender);
        $conn->bindParam(':recipient', $this->recipient);
        $conn->bindParam(':transferAmount', $this->transferAmount);
        $conn->bindParam(':transProDate', $this->transProDate);
        $conn->bindParam(':transferFee', $this->transferFee);
        $conn->bindParam(':percentage', $this->percentage);
        $conn->bindParam(':transfeeStatus', $this->transfeeStatus);
        $conn->bindParam(':maturityDate', $this->maturityDate);
        $conn->bindParam(':maturityDateStatus', $this->maturityDateStatus); 
        $conn->bindParam(':country', $this->country);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function saveProgress()
    {


        $sql = "INSERT INTO `progress`(id,sender,reciepient,Transferamount,transProDate,TransferFee,percentage,transfeeStatus,maturityDate,maturityDateStatus,enctryption,TransId,Country,message,currency) VALUES ( NULL,:sender, :recipient, :transferAmount, :transProDate, :transferFee, :percentage, :transfeeStatus, :maturityDate, :maturityDateStatus, :encryption,:TransId,:Country,:message,:currency)";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(':sender', $this->sender);
        $conn->bindParam(':recipient', $this->recipient);
        $conn->bindParam(':transferAmount', $this->transferAmount);
        $conn->bindParam(':transProDate', $this->transProDate);
        $conn->bindParam(':transferFee', $this->transferFee);
        $conn->bindParam(':percentage', $this->percentage);
        $conn->bindParam(':transfeeStatus', $this->transfeeStatus);
        $conn->bindParam(':maturityDate', $this->maturityDate);
        $conn->bindParam(':maturityDateStatus', $this->maturityDateStatus);
        $conn->bindParam(':encryption', $this->encryption);
        $conn->bindParam(':TransId', $this->id);
        $conn->bindParam(':Country', $this->country);
        $conn->bindParam(':message', $this->epin);
        $conn->bindParam(':currency', $this->pin);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function save_loan()
    {
        $sql = "INSERT INTO `loan`(id, loan_type, amount, Duration, employment_status, trans_id, status, userid)VALUES(NULL, :fname, :middlename, :lname, :email, :tel_number, :postal_code, :currency)";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":fname", $this->fname);
        $conn->bindParam(":middlename", $this->middlename);
        $conn->bindParam(":lname", $this->lname);
        $conn->bindParam(":email", $this->email);
        $conn->bindParam(":tel_number", $this->tel_number);
        $conn->bindParam(":postal_code", $this->postal_code);
        $conn->bindParam(":currency", $this->currency);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function save_check()
    {
        $sql = "INSERT INTO `cheque_deposit`(id, Front_Page, Back_Page, Bank_Name, Amount, trans_id, status, userid)VALUES(NULL, :fname, :middlename, :lname, :email, :tel_number, :postal_code, :currency)";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":fname", $this->fname);
        $conn->bindParam(":middlename", $this->middlename);
        $conn->bindParam(":lname", $this->lname);
        $conn->bindParam(":email", $this->email);
        $conn->bindParam(":tel_number", $this->tel_number);
        $conn->bindParam(":postal_code", $this->postal_code);
        $conn->bindParam(":currency", $this->currency);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function update($get)
    {
        $sql = "UPDATE `users` SET tel_number = :tel_number, email = :email, balance = :balance, dob = :dob, date_registered = :date_registered, pin = :epin  WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":email", $this->email);
        $conn->bindParam(":tel_number", $this->tel_number);
        $conn->bindParam(":dob", $this->dob);
        $conn->bindParam(":balance", $this->balance);
        $conn->bindParam(":date_registered", $this->dis);
        $conn->bindParam(":epin", $this->epin);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function update_trans_code($get)
    {
        $sql = "UPDATE `users` SET  PersonalTransactionKey = :dob, TaxClearanceCode = :tel_number, IMFClearanceCode  = :balance, AntiTerrorismClearanceCode = :email WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":email", $this->email);
        $conn->bindParam(":tel_number", $this->tel_number);
        $conn->bindParam(":dob", $this->dob);
        $conn->bindParam(":balance", $this->balance);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function update_code_number($get)
    {
        $sql = "UPDATE `users` SET num = :date_registered WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":date_registered", $this->dis);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function update_transaction_2($get)
    {
        //   $sql = "UPDATE `transactions` SET recipient_acc = ':fname', sender_acc = ':middlename', date_of_trans = ':lname', recipient_name = ':email', bank = ':tel_number', trans_des = ':postal_code', from_ = ':gender', status = ':currency'  WHERE id = '$get'";
        // $conn = $this->dbconn->prepare($sql);
        // $conn->bindParam(":fname", $this->fname);
        // $conn->bindParam(":middlename", $this->middlename);
        // $conn->bindParam(":lname", $this->lname);
        // $conn->bindParam(":email", $this->email);
        // $conn->bindParam(":tel_number", $this->tel_number);
        // $conn->bindParam(":postal_code", $this->postal_code);
        // $conn->bindParam(":gender", $this->gender);
        // $conn->bindParam(":currency", $this->currency);
        // // $conn->bindParam(":country", $this->country);
        // // $conn->bindParam(":state", $this->state);

        $sql = "UPDATE `transactions` SET recipient_acc = :fname, sender_acc = :middlename, date_of_trans = :lname, recipient_name = :email, bank = :tel_number, trans_des = :postal_code, from_ = :gender, status = :currency  WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":fname", $this->fname);
        $conn->bindParam(":middlename", $this->middlename);
        $conn->bindParam(":lname", $this->lname);
        $conn->bindParam(":email", $this->email);
        $conn->bindParam(":tel_number", $this->tel_number);
        $conn->bindParam(":postal_code", $this->postal_code);
        $conn->bindParam(":gender", $this->gender);
        $conn->bindParam(":currency", $this->currency);

        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }



    public function update_profiles_with_id($get)
    {
        $sql = "UPDATE `users` SET tel_number = :tel_number, address = :address,  state = :state, ssn = :ssn  WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":tel_number", $this->tel_number);
        $conn->bindParam(":ssn", $this->ssn);
        $conn->bindParam(":address", $this->address);
        $conn->bindParam(":state", $this->state);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function check_Email($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE email = :email");
        $conn->bindParam(":email", $data);
        $conn->execute();
        $count = $conn->rowCount();

        if ($count >= 1) {
            return true;
        } else {
            return false;
        }
    }

    public function updatepass($id)
    {
        $sql = "UPDATE `users` SET pass = :pass, password = :password  WHERE id = '$id'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":pass", $this->pass);
        $conn->bindParam(":password", $this->password);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function updateprofile($id)
    {
        $sql = "UPDATE `users` SET profile_pic = :pass  WHERE id = '$id'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":pass", $this->pass);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function updatepin($id)
    {
        $sql = "UPDATE `users` SET pin = :pass  WHERE id = '$id'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":pass", $this->pass);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function update_pass_with_email($data)
    {

        $sql = "UPDATE `users` SET pass = :pass, password = :password  WHERE email = '$data'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":pass", $this->pass);
        $conn->bindParam(":password", $this->password);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function updatetel()
    {
        $id = $_SESSION["id"];
        $sql = "UPDATE `users` SET tel_number = :pass WHERE id = '$id'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":pass", $this->tel_number);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }
    public function updatemail()
    {
        $id = $_SESSION["id"];
        $sql = "UPDATE `users` SET email = :pass WHERE id = '$id'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":pass", $this->email);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function check_PIN()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `users`  confirm IS NULL OR
confirm = ' ' AND id = '$get'");
        $count = $conn->execute();

        if ($count) {
            return true;
        } else {
            return false;
        }
    }


    public function fetch_data($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE email = :email");
        $conn->bindParam(":email", $data);
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);

        return $pass;
    }

    public function check_Email_fetch($data, $data1)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE email = :email AND id = :userid");
        $conn->bindParam(":email", $data);
        $conn->bindParam(":userid", $data1);
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function fetch_verification_code()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `verify` WHERE email = :email");
        $conn->bindParam(":email", $this->email);
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_data_with_email($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE email = '$data'");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_number_pin($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE pin = :epin");
        $conn->bindParam(":epin", $data);
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function fetch_transaction()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id = '$get' ORDER BY id DESC  LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function V_login($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `account` WHERE email = :email");
        $conn->bindParam(":email", $data);
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        $_SESSION["ID"] = $fetch["id"];
        return true;
    }

    public function fetch()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function validatePassword($password)
    {
        if (preg_match('/^(?=.*\d)(?=.*[@#\-_$%^&+=§!\?])(?=.*[a-z])(?=.*[A-Z])[0-9A-Za-z@#\-_$%^&+=§!\?]{8,20}$/', $password)) {
            return true;
        } else {
            return false;
        }
    }

    public function v_passess($password)
    {
        if (preg_match("#.*^(?=.{8,20})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*\W).*$#", $password)) {
            return true;
        } else {
            return false;
        }
    }

    public function v_passd($password)
    {
        if (preg_match("#.*^(?=.{8,20})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).*$#", $password)) {
            return true;
        } else {
            return false;
        }
    }

    public function check_Acc_num($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE account_number = :Acc_num");
        $conn->bindParam(":Acc_num", $data);
        $conn->execute();
        $count = $conn->rowCount();

        if ($count >= 1) {
            return true;
        } else {
            return false;
        }
    }

    public function delite_user($get)
    {

        $sql = "DELETE FROM `users` WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }
    public function deliteProgress($get)
    {

        $sql = "DELETE FROM `progress` WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function delite_tran($get)
    {

        $sql = "DELETE FROM `transactions` WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function delite_transaction_with_hash($get)
    {

        $sql = "DELETE FROM `on` WHERE trans_id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function fetch_Admin($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `administrators` WHERE email = :sender_acc");
        $conn->bindParam(":sender_acc", $data);
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function decode($protect)
    {
        return hash('sha256', $protect);
    }

    public function random_strings($length_of_string)
    {

        // String of all alphanumeric character
        $str_result = '012345678990123456789980650403030306';
        $str_result .= '98765432100299388858857657689202890';
        $str_result .= '98712354607846583940030394048408392';
        // Shufle the $str_result and returns substring
        // of specified length
        return substr(str_shuffle($str_result), 0, $length_of_string);
    }

    public function fetch_fund_acc()
    {

        $get = $_GET["aid"];
        $sql = "SELECT * FROM `account` WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;

    }


    public function updatefunds($get)
    {
        $sql = "UPDATE `users`  SET balance = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->balance);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }


    public function update__restrict()
    {
        $get = $_GET["aid"];
        $sql = "UPDATE `users` SET code = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->code);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function update_kk_restrict($get)
    {
        $sql = "UPDATE `users` SET num = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->code);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }



    public function update_status($get)
    {
        $sql = "UPDATE `transactions`  SET status = :status WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->status);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }



    public function facebook_time_ago($timestamp)
    {
        $time_ago = strtotime($timestamp);
        $current_time = time();
        $time_difference = $current_time - $time_ago;
        $seconds = $time_difference;
        $minutes      = round($seconds / 60);           // value 60 is seconds
        $hours           = round($seconds / 3600);           //value 3600 is 60 minutes * 60 sec
        $days          = round($seconds / 86400);          //86400 = 24 * 60 * 60;
        $weeks          = round($seconds / 604800);          // 7*24*60*60;
        $months          = round($seconds / 2629440);     //((365+365+365+365+366)/5/12)*24*60*60
        $years          = round($seconds / 31553280);     //(365+365+365+365+366)/5 * 24 * 60 * 60
        if($seconds <= 60) {
            return "Just Now";
        } elseif($minutes <= 60) {
            if($minutes == 1) {
                return "one minute ago";
            } else {
                return "$minutes minutes ago";
            }
        } elseif($hours <= 24) {
            if($hours == 1) {
                return "an hour ago";
            } else {
                return "$hours hrs ago";
            }
        } elseif($days <= 7) {
            if($days == 1) {
                return "yesterday";
            } else {
                return "$days days ago";
            }
        } elseif($weeks <= 4.3) { //4.3 == 52/12
            if($weeks == 1) {
                return "a week ago";
            } else {
                return "$weeks weeks ago";
            }
        } elseif($months <= 12) {
            if($months == 1) {
                return "a month ago";
            } else {
                return "$months months ago";
            }
        } else {
            if($years == 1) {
                return "one year ago";
            } else {
                return "$years years ago";
            }
        }
    }

    public function updatestat()
    {
        $get = $_GET["aid"];

        $sql = "UPDATE `users` SET allowed = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->status);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function updateverify()
    {
        $get = $_GET["aid"];
        $sql = "UPDATE `transaction` SET status = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->status);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }


    public function update_restrict()
    {
        $get = $_GET["aid"];
        $sql = "UPDATE `users` SET allowed = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->allowed);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function update_bit()
    {
        $get = $_GET["aid"];
        $sql = "UPDATE `users` SET biterr = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->allowed);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function disallowlogin()
    {
        $get = $_GET["aid"];
        $sql = "UPDATE `users` SET dis = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->dislog);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }


    public function fetch_card($get)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }
    public function fetchProgress($get)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `progress` WHERE id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function fetch_transaction_w($get)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
        var_dump($conn);
    }

    public function fetch_timezone()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `time_zone` ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function fetch_c_()
    {
        $get = $_GET["aid"];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function fetch_c()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function fetc_c()
    {
        $get = $_GET["aid"];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function fetch_card_details()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `card` WHERE userid = '$get'");
        $conn->execute();
        $count = $conn->fetch(PDO::FETCH_ASSOC);
        return $count;

    }

    public function verify()
    {
        $sql = "INSERT INTO `verify`(code, email, mail)VALUES(:code, :email, :mail)";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":email", $this->email);
        $conn->bindParam(":code", $this->code);
        $conn->bindParam(":mail", $this->pin);
        if ($conn->execute()) {
            return true;
            return true;
        } else {
            return false;
        }

    }

    public function verify_forgotten()
    {
        $sql = "INSERT INTO `forgot_pass`(token, email, pin, userid)VALUES(:token, :email, :pin, :id)";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":token", $this->code);
        $conn->bindParam(":email", $this->email);
        $conn->bindParam(":pin", $this->pin);
        $conn->bindParam(":id", $this->id);
        if ($conn->execute()) {
            return true;
            return true;
        } else {
            return false;
        }

    }

    public function check_username($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE username = :email");
        $conn->bindParam(":email", $data);
        $conn->execute();
        $count = $conn->rowCount();

        if ($count >= 1) {
            return true;
        } else {
            return false;
        }
    }

    public function fetch_All_user_from_db()
    {

        $conn = $this->dbconn->prepare("SELECT * FROM `users`ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;
    }
    public function fetchAllProgress()
    {

        $conn = $this->dbconn->prepare("SELECT * FROM `progress`ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_data1($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE account_number = :email");
        $conn->bindParam(":email", $data);
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_trans_vals($get)
    {

        $conn = $this->dbconn->prepare("SELECT * FROM `on` WHERE sender_id = '$get' ORDER BY id DESC LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_tbit()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transact` WHERE userid = '$get' ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_tbit_ID()
    {
        $get = $_GET['aid'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transact` WHERE userid = '$get' ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }


    public function fetch_trans_vals_inter()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `inter` WHERE sender_id = '$get' ORDER BY id DESC LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_card_id($get)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users` WHERE id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }
    public function fetchProgressWithTransid($get)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `progress` WHERE TransId = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function Trans_funds($get)
    {
        $sql = "UPDATE `users` SET balance = :bank_accbal WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":bank_accbal", $this->balance);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }

    }

    public function fetch_otp()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `code` WHERE sender_id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function count_total_user()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users`");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;

    }

    public function count_total_deposit()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE type_of = 'credit'");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;

    }

    public function count_total_withdrawal()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE type_of = 'debit'");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;

    }

    public function fetch_otp_inter()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `co` WHERE sender_id = '$get' ORDER BY id DESC");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function check_num()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `users` ORDER BY id");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;

    }

    public function count_all_transactions()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` ORDER BY id");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;

    }



    public function fetch_all_transactions()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` ORDER BY id");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function check_declined_transaction()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id='$get' AND type_of='debit' ORDER BY id DESC LIMIT 4");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function check_last_declined_transaction($get)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id='$get' AND status = 'insufficient funds' ORDER BY id DESC ");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;
    }

    public function check_random_transaction()
    {
        $get = $_GET['aid'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE id='$get' ORDER BY id DESC LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function check_inter_details()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `inter` WHERE sender_id='$get' AND type_of='debit' ORDER BY id DESC LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function check_local_details()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id='$get' AND type_of='debit' ORDER BY id DESC LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function check_approved_transaction($get)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id='$get' AND status = 'Approved' ORDER BY id DESC ");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;

    }

    public function check_bit_transaction()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id='$get' AND type_of = 'bitcoin' AND status = 'Approved' ORDER BY id DESC ");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function check_last_approved_transaction($get)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `on` WHERE sender_id='$get' ORDER BY id DESC ");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;
    }

    public function fetch_wallet_only()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `add` ORDER BY id DESC LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function check_all_transaction()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id='$get' ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function check_1_transaction()
    {
        $get = $_GET['aid'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE id='$get'");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function fetch_Admin_by_id($data)
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `administrators` WHERE id = '$data'");
        $conn->execute();
        $fetch = $conn->fetch(PDO::FETCH_ASSOC);
        return $fetch;
    }

    public function check_all_4($get)
    {

        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id ='$get' ORDER BY id DESC ");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function fetch_1transaction($get)
    {

        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id ='$get' ORDER BY id DESC Limit 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }


    public function fetch_all_beneficiary()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `beneficiary` WHERE userid='$get' ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function fetch_beneficiary_by_session_id()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `beneficiary` WHERE userid='$get' ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function fetch_ongoing_transaction_by_session_id()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `on` WHERE sender_id='$get' ORDER BY id DESC LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function fetch_2_beneficies()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `beneficiary` WHERE userid='$get' ORDER BY id DESC Limit 2");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }


    public function check_all_inter()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `inter_transaction` WHERE sender_id='$get' ORDER BY id DESC LIMIT 10");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function check_all_()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE sender_id='$get' ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }


    public function Fetch_All()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `users`");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_All_tra()
    {
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions`");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function delite_beneficiary()
    {
        $get = $_GET["aid"];
        $sql = "DELETE FROM `beneficiary` WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function transact()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE userid='$get'  ORDER BY id DESC LIMIT 5");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function lastrans()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `deposit` WHERE userid='$get' ORDER  BY id DESC   LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }



    public function selectdep()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `deposit` WHERE userid='$get' ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function with()
    {
        $get = $_GET["aid"];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE id = '$get'");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function withrawal()
    {
        $get = $_GET["aid"];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE id = '$get'");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }



    public function sumdeposit()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT SUM(amount) as sum FROM `transaction` WHERE type = 'deposit' AND userid='$get'");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function sumdebit()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT SUM(amount) as sum FROM `transactions` WHERE type_of = 'debit' AND sender_id='$get' AND status='Approved'");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function lastdeposit()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE userid='$get' AND type='deposit' ORDER  BY id DESC   LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function deposit()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE  type= 'deposit' AND userid='$get'");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function lastwithdrawal()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE type = 'withdrawal' AND userid='$get' ORDER  BY id DESC   LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function fetch_all_withdrawal()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transactions` WHERE type_of = 'debit' AND sender_id='$get' ORDER BY id DESC");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;
    }

    public function withdrawalamount()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT SUM(amount) as width FROM `transaction` WHERE type = 'withdrawal' AND userid='$get'");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }



    public function sumprofit()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT SUM(amount) as profit FROM `transaction` WHERE type = 'profit' AND userid='$get'");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function deposit_Amount()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `deposit` WHERE userid = '$get' ORDER BY id DESC LIMIT 1");
        $conn->execute();
        $pass = $conn->fetch(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function call()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE userid = '$get'");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function img()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `img` ORDER BY id DESC LIMIT 3");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function delit()
    {
        $sql = "DELETE FROM `verify` WHERE id = ':id'";
        $conn = $this->dbconn->prepare($sql);
        $conn->bindParam(":id", $this->id);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function delite_card()
    {
        $get = $_GET["aid"];
        $sql = "DELETE FROM `transactions` WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function delite_users()
    {
        $get = $_GET["aid"];
        $sql = "DELETE FROM `users` WHERE id = '$get'";
        $conn = $this->dbconn->prepare($sql);
        if ($conn->execute()) {
            return true;
        } else {
            return false;
        }
    }

    public function imgg()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `img` ");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function img_1()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `img` ORDER BY id ASC LIMIT 3");
        $conn->execute();
        $pass = $conn->fetchAll(PDO::FETCH_ASSOC);
        return $pass;

    }

    public function count_deposit()
    {
        $get = $_SESSION['id'];
        $conn = $this->dbconn->prepare("SELECT * FROM `transaction` WHERE type = 'deposit' AND userid = '$get'");
        $conn->execute();
        $count = $conn->rowCount();
        return $count;
    }

}


//https://www.templatesthemes.net/view.php?id=85830 - flutter/firebase app
